# Instalación de Laravel con Orchid usando XAMPP

Este documento describe el proceso completo para instalar un proyecto **Laravel limpio** e integrar el **panel de administración Orchid**, configurando correctamente el entorno con **XAMPP** en Windows.

---

## 🧩 Requisitos previos

- PHP 8.1 o superior (incluido en XAMPP)
- Composer instalado
- Node.js instalado globalmente
- XAMPP con Apache y MySQL activos

---

## 🚀 1. Crear un nuevo proyecto Laravel

Desde la consola (PowerShell o CMD):

```bash
cd C:\xampp\htdocs
composer create-project laravel/laravel GCE
```

---

## ⚙️ 2. Instalar Orchid Platform

Dentro del proyecto:
```bash
cd GCE
composer require orchid/platform
```

Luego ejecutar el instalador:
```bash
php artisan orchid:install
```

Durante la instalación:
- Puedes responder “no” a la pregunta sobre dejar una ⭐ en GitHub.
- Acepta publicar los assets si lo pregunta.

---

## 🧠 3. Configurar la base de datos

Editar el archivo .env en la raíz del proyecto:
```bash
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=gce
DB_USERNAME=root
DB_PASSWORD=
```
Nota: crea la base de datos gce en phpMyAdmin antes de continuar, o Laravel la creará automáticamente al ejecutar migrate.

---

## 🧱 4. Ejecutar migraciones

Crea las tablas necesarias para Laravel y Orchid:
```bash
php artisan migrate
```

Si pregunta: The database 'gce' does not exist. Would you like to create it? (yes/no)
Responde: yes

---
## 👤 5. Crear usuario administrador
Genera un usuario para acceder al panel:
```bash
php artisan orchid:admin admin admin@admin.com password
```

---

## 🌐 6. Configurar VirtualHost en XAMPP

En lugar de modificar el archivo httpd.conf, se recomienda usar VirtualHosts, ya que permite tener varios proyectos funcionando en paralelo sin interferencias.

1. Abre el archivo  
   C:\xampp\apache\conf\extra\httpd-vhosts.conf

2. Agrega al final este bloque:

```apache
    # Proyecto GCE
    <VirtualHost *:80>
        ServerName gce.localhost
        DocumentRoot "C:/xampp/htdocs/gce/public"
        <Directory "C:/xampp/htdocs/gce/public">
            AllowOverride All
            Require all granted
        </Directory>
    </VirtualHost>
```

3. Abre el archivo hosts de Windows:  
```bash
C:\Windows\System32\drivers\etc\hosts
```

   y agrega al final:
```bash
127.0.0.1   gce.localhost
```


4. Guarda los cambios y reinicia Apache desde el panel de control de XAMPP.

Después de esto, podrás acceder al proyecto directamente desde
```bash
http://gce.localhost/admin  
```
en lugar de usar rutas con /public/.


---

## 🔑 7. Acceder al panel Orchid
Abrir el navegador y acceder a:
```bash
http://localhost/admin
```
Ingresar con las credenciales que generaste.

---
