<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Adscripto extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'user_id',
        'fecha_ingreso',
        'observaciones',
    ];

    protected $casts = [
        'fecha_ingreso' => 'date',
    ];

    /**
     * Relación con User
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relación muchos a muchos con Docente
     */
    public function docentes(): BelongsToMany
    {
        return $this->belongsToMany(Docente::class, 'adscripto_docentes', 'adscripto_id', 'docente_id')
            ->withTimestamps();
    }

    /**
     * Relación muchos a muchos con Grupo
     */
    public function grupos(): BelongsToMany
    {
        return $this->belongsToMany(Grupo::class, 'adscripto_grupos', 'adscripto_id', 'grupo_id')
            ->withTimestamps();
    }
}
