<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AdscriptoDocente extends Model
{
    public $incrementing = false;
    protected $primaryKey = null;

    protected $fillable = [
        'adscripto_id',
        'docente_id',
    ];

    /**
     * Relación con Adscripto
     */
    public function adscripto(): BelongsTo
    {
        return $this->belongsTo(Adscripto::class, 'adscripto_id');
    }

    /**
     * Relación con Docente
     */
    public function docente(): BelongsTo
    {
        return $this->belongsTo(Docente::class, 'docente_id');
    }
}
