<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AdscriptoGrupo extends Model
{
    public $incrementing = false;
    protected $primaryKey = null;

    protected $fillable = [
        'adscripto_id',
        'grupo_id',
    ];

    /**
     * Relación con Adscripto
     */
    public function adscripto(): BelongsTo
    {
        return $this->belongsTo(Adscripto::class, 'adscripto_id');
    }

    /**
     * Relación con Grupo
     */
    public function grupo(): BelongsTo
    {
        return $this->belongsTo(Grupo::class, 'grupo_id');
    }
}
