<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Asignatura extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'nombre',
    ];

    /**
     * Relación muchos a muchos con Docente y Grupo
     */
    public function docentes(): BelongsToMany
    {
        return $this->belongsToMany(Docente::class, 'docente_asignatura_grupos', 'asignatura_id', 'docente_id')
            ->withPivot('grupo_id')
            ->withTimestamps();
    }

    /**
     * Relación muchos a muchos con Grupo a través de Docente
     */
    public function grupos(): BelongsToMany
    {
        return $this->belongsToMany(Grupo::class, 'docente_asignatura_grupos', 'asignatura_id', 'grupo_id')
            ->withPivot('docente_id')
            ->withTimestamps();
    }

    /**
     * Relación uno a muchos con Calificacion
     */
    public function calificaciones(): HasMany
    {
        return $this->hasMany(Calificacion::class, 'asignatura_id');
    }

    /**
     * Relación uno a muchos con CalificacionPeriodo
     */
    public function calificacionesPeriodo(): HasMany
    {
        return $this->hasMany(CalificacionPeriodo::class, 'asignatura_id');
    }
}
