<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Calificacion extends Model
{
    use AsSource, Filterable;

    public $incrementing = false;
    protected $primaryKey = null;

    protected $table = 'calificacion_mensual';

    protected $fillable = [
        'alumno_id',
        'asignatura_id',
        'docente_id',
        'mes',
        'anio',
        'numero',
        'nota',
        'comentario',
    ];

    protected $casts = [
        'mes' => 'integer',
        'anio' => 'integer',
        'numero' => 'integer',
        'nota' => 'decimal:2',
    ];

    /**
     * Relación con Alumno
     */
    public function alumno(): BelongsTo
    {
        return $this->belongsTo(Alumno::class, 'alumno_id');
    }

    /**
     * Relación con Asignatura
     */
    public function asignatura(): BelongsTo
    {
        return $this->belongsTo(Asignatura::class, 'asignatura_id');
    }

    /**
     * Relación con Docente
     */
    public function docente(): BelongsTo
    {
        return $this->belongsTo(Docente::class, 'docente_id');
    }
}
