<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class CalificacionPeriodo extends Model
{
    use AsSource, Filterable;

    public $incrementing = false;
    protected $primaryKey = null;

    protected $table = 'calificacion_periodo';

    protected $fillable = [
        'alumno_id',
        'asignatura_id',
        'docente_id',
        'periodo_id',
        'nota',
        'comentario',
    ];

    protected $casts = [
        'nota' => 'decimal:2',
    ];

    /**
     * Relación con Alumno
     */
    public function alumno(): BelongsTo
    {
        return $this->belongsTo(Alumno::class, 'alumno_id');
    }

    /**
     * Relación con Asignatura
     */
    public function asignatura(): BelongsTo
    {
        return $this->belongsTo(Asignatura::class, 'asignatura_id');
    }

    /**
     * Relación con Docente
     */
    public function docente(): BelongsTo
    {
        return $this->belongsTo(Docente::class, 'docente_id');
    }

    /**
     * Relación con Periodo
     */
    public function periodo(): BelongsTo
    {
        return $this->belongsTo(Periodo::class, 'periodo_id');
    }
}
