<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Ciclo extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'nombre',
    ];

    /**
     * Relación muchos a muchos con Colegio a través de ColegioCiclo
     */
    public function colegios(): BelongsToMany
    {
        return $this->belongsToMany(Colegio::class, 'colegio_ciclos', 'ciclo_id', 'colegio_id')
            ->withTimestamps();
    }

    /**
     * Relación con ColegioCiclo
     */
    public function colegioCiclos()
    {
        return $this->hasMany(ColegioCiclo::class, 'ciclo_id');
    }
}
