<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Colegio extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'nombre',
        'direccion',
    ];

    /**
     * Relación muchos a muchos con Ciclo a través de ColegioCiclo
     */
    public function ciclos(): BelongsToMany
    {
        return $this->belongsToMany(Ciclo::class, 'colegio_ciclos', 'colegio_id', 'ciclo_id')
            ->withTimestamps();
    }

    /**
     * Relación con ColegioCiclo
     */
    public function colegioCiclos()
    {
        return $this->hasMany(ColegioCiclo::class, 'colegio_id');
    }
}
