<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class ColegioCiclo extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'colegio_id',
        'ciclo_id',
    ];

    /**
     * Relación con Colegio
     */
    public function colegio(): BelongsTo
    {
        return $this->belongsTo(Colegio::class, 'colegio_id');
    }

    /**
     * Relación con Ciclo
     */
    public function ciclo(): BelongsTo
    {
        return $this->belongsTo(Ciclo::class, 'ciclo_id');
    }

    /**
     * Relación uno a muchos con Grupo
     */
    public function grupos(): HasMany
    {
        return $this->hasMany(Grupo::class, 'colegio_ciclo_id');
    }

    /**
     * Accessor para mostrar el nombre completo
     */
    public function getNombreAttribute(): string
    {
        if (!$this->relationLoaded('colegio')) {
            $this->load('colegio');
        }
        if (!$this->relationLoaded('ciclo')) {
            $this->load('ciclo');
        }
        $colegio = $this->colegio ? $this->colegio->nombre : '';
        $ciclo = $this->ciclo ? $this->ciclo->nombre : '';
        return $colegio && $ciclo ? $colegio . ' - ' . $ciclo : ($colegio ?: $ciclo ?: 'ID: ' . $this->id);
    }
}
