<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Grupo extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'colegio_ciclo_id',
        'turno_id',
        'nombre_grupo',
    ];

    /**
     * Relación con ColegioCiclo
     */
    public function colegioCiclo(): BelongsTo
    {
        return $this->belongsTo(ColegioCiclo::class, 'colegio_ciclo_id');
    }

    /**
     * Relación con Turno
     */
    public function turno(): BelongsTo
    {
        return $this->belongsTo(Turno::class, 'turno_id');
    }

    /**
     * Relación muchos a muchos con Docente y Asignatura
     */
    public function docentes(): BelongsToMany
    {
        return $this->belongsToMany(Docente::class, 'docente_asignatura_grupos', 'grupo_id', 'docente_id')
            ->withPivot('asignatura_id')
            ->withTimestamps();
    }

    /**
     * Relación muchos a muchos con Asignatura a través de Docente
     */
    public function asignaturas(): BelongsToMany
    {
        return $this->belongsToMany(Asignatura::class, 'docente_asignatura_grupos', 'grupo_id', 'asignatura_id')
            ->withPivot('docente_id')
            ->withTimestamps();
    }

    /**
     * Relación muchos a muchos con Adscripto
     */
    public function adscriptos(): BelongsToMany
    {
        return $this->belongsToMany(Adscripto::class, 'adscripto_grupos', 'grupo_id', 'adscripto_id')
            ->withTimestamps();
    }

    /**
     * Relación muchos a muchos con Alumno
     */
    public function alumnos(): BelongsToMany
    {
        return $this->belongsToMany(Alumno::class, 'alumno_grupos', 'grupo_id', 'alumno_id')
            ->withTimestamps();
    }

    /**
     * Relación uno a muchos con Calificacion
     */
    public function calificaciones()
    {
        return $this->hasMany(Calificacion::class, 'grupo_id');
    }
}
