<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Padre extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'user_id',
        'tipo_relacion',
        'observaciones',
    ];

    /**
     * Relación con User
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relación muchos a muchos con Alumno
     */
    public function alumnos(): BelongsToMany
    {
        return $this->belongsToMany(Alumno::class, 'padre_alumnos', 'padre_id', 'alumno_id')
            ->withTimestamps();
    }

    /**
     * Accessor para mostrar el nombre del usuario
     */
    public function getNombreCompletoAttribute(): string
    {
        if (!$this->relationLoaded('user')) {
            $this->load('user');
        }
        return $this->user ? $this->user->name . ' ' . ($this->user->apellido ?? '') : 'ID: ' . $this->id;
    }
}
