<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PadreAlumno extends Model
{
    public $incrementing = false;
    protected $primaryKey = null;

    protected $fillable = [
        'padre_id',
        'alumno_id',
    ];

    /**
     * Relación con Padre
     */
    public function padre(): BelongsTo
    {
        return $this->belongsTo(Padre::class, 'padre_id');
    }

    /**
     * Relación con Alumno
     */
    public function alumno(): BelongsTo
    {
        return $this->belongsTo(Alumno::class, 'alumno_id');
    }
}
