<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Periodo extends Model
{
    use AsSource, Filterable;

    protected $fillable = [
        'nombre',
        'fecha_inicio',
        'fecha_fin',
    ];

    protected $casts = [
        'fecha_inicio' => 'date',
        'fecha_fin' => 'date',
    ];

    /**
     * Relación uno a muchos con CalificacionPeriodo
     */
    public function calificacionesPeriodo(): HasMany
    {
        return $this->hasMany(CalificacionPeriodo::class, 'periodo_id');
    }
}
