<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Orchid\Filters\Filterable;
use Orchid\Screen\AsSource;

class Turno extends Model
{
    use AsSource, Filterable;
    protected $fillable = [
        'nombre',
    ];

    /**
     * Relación uno a muchos con Grupo
     */
    public function grupos(): HasMany
    {
        return $this->hasMany(Grupo::class, 'turno_id');
    }
}
