<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Adscripto;

use App\Models\User;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\DateTimer;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Fields\TextArea;
use Orchid\Screen\Layouts\Rows;

class AdscriptoEditLayout extends Rows
{
    public function fields(): array
    {
        return [
            Relation::make('adscripto.user_id')
                ->fromModel(User::class, 'name')
                ->applyScope('withAdscriptoRole')
                ->title(__('Usuario'))
                ->required(),
            DateTimer::make('adscripto.fecha_ingreso')->title(__('Fecha de Ingreso'))->format('Y-m-d')->allowInput(),
            TextArea::make('adscripto.observaciones')->title(__('Observaciones'))->rows(3),
        ];
    }
}

