<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Adscripto;

use App\Models\Adscripto;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class AdscriptoListLayout extends Table
{
    public $target = 'adscriptos';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))->sort()->cantHide(),
            TD::make('user_id', __('Usuario'))
                ->render(fn (Adscripto $adscripto) => $adscripto->user ? $adscripto->user->name . ' ' . ($adscripto->user->apellido ?? '') : '-'),
            TD::make('fecha_ingreso', __('Fecha Ingreso'))
                ->render(fn (Adscripto $adscripto) => $adscripto->fecha_ingreso ? $adscripto->fecha_ingreso->format('d/m/Y') : '-'),
            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Adscripto $adscripto) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))->route('platform.systems.adscriptos.edit', $adscripto->id)->icon('bs.pencil'),
                        Button::make(__('Eliminar'))->icon('bs.trash3')->confirm(__('¿Está seguro?'))->method('remove', ['id' => $adscripto->id]),
                    ])),
        ];
    }
}

