<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Alumno;

use App\Models\Alumno;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class AlumnoListLayout extends Table
{
    public $target = 'alumnos';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide()
                ->filter(Input::make()),

            TD::make('user_id', __('Usuario'))
                ->sort()
                ->render(fn (Alumno $alumno) => $alumno->user ? $alumno->user->name . ' ' . ($alumno->user->apellido ?? '') : '-'),

            TD::make('fecha_ingreso', __('Fecha Ingreso'))
                ->sort()
                ->render(fn (Alumno $alumno) => $alumno->fecha_ingreso ? $alumno->fecha_ingreso->format('d/m/Y') : '-'),

            TD::make('grupos', __('Grupos'))
                ->render(function (Alumno $alumno) {
                    if ($alumno->grupos->isEmpty()) {
                        return '<span class="text-muted">-</span>';
                    }
                    return $alumno->grupos->pluck('nombre_grupo')->join(', ');
                }),

            TD::make('nombre_contacto_emergencia', __('Contacto Emergencia'))
                ->sort(),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Alumno $alumno) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Ver Detalles'))
                            ->route('platform.systems.alumnos.show', $alumno->id)
                            ->icon('bs.eye'),
                        Link::make(__('Editar'))
                            ->route('platform.systems.alumnos.edit', $alumno->id)
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro de eliminar este alumno?'))
                            ->method('remove', ['id' => $alumno->id]),
                    ])),
        ];
    }
}

