<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Asignatura;

use App\Models\Asignatura;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class AsignaturaListLayout extends Table
{
    public $target = 'asignaturas';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide()
                ->filter(Input::make()),

            TD::make('nombre', __('Nombre'))
                ->sort()
                ->cantHide()
                ->filter(Input::make())
                ->render(fn (Asignatura $asignatura) => Link::make($asignatura->nombre)
                    ->route('platform.systems.asignaturas.edit', $asignatura->id)),

            TD::make('created_at', __('Creado'))
                ->sort()
                ->render(fn (Asignatura $asignatura) => $asignatura->created_at->format('d/m/Y H:i')),

            TD::make('updated_at', __('Actualizado'))
                ->sort()
                ->render(fn (Asignatura $asignatura) => $asignatura->updated_at->format('d/m/Y H:i')),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Asignatura $asignatura) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.asignaturas.edit', $asignatura->id)
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro de eliminar esta asignatura?'))
                            ->method('remove', ['id' => $asignatura->id]),
                    ])),
        ];
    }
}

