<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Calificacion;

use App\Models\Alumno;
use App\Models\Asignatura;
use App\Models\Docente;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Fields\Select;
use Orchid\Screen\Fields\TextArea;
use Orchid\Screen\Layouts\Rows;

class CalificacionEditLayout extends Rows
{
    public function fields(): array
    {
        $meses = [
            1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril',
            5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto',
            9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
        ];

        return [
            Relation::make('calificacion.alumno_id')
                ->fromModel(Alumno::class, 'id')
                ->title(__('Alumno'))
                ->required()
                ->searchColumns('id')
                ->displayAppend('nombre_completo'),
            Relation::make('calificacion.asignatura_id')
                ->fromModel(Asignatura::class, 'nombre')
                ->title(__('Asignatura'))
                ->required(),
            Relation::make('calificacion.docente_id')
                ->fromModel(Docente::class, 'id')
                ->title(__('Docente'))
                ->required()
                ->searchColumns('id')
                ->displayAppend('nombre_completo'),
            Select::make('calificacion.mes')
                ->title(__('Mes'))
                ->options($meses)
                ->required(),
            Input::make('calificacion.anio')
                ->type('number')
                ->title(__('Año'))
                ->required()
                ->min(2000)
                ->max(2100),
            Input::make('calificacion.nota')
                ->type('number')
                ->step(0.01)
                ->title(__('Nota'))
                ->placeholder(__('Nota (ej: 8.5)'))
                ->min(0)
                ->max(10),
            TextArea::make('calificacion.comentario')
                ->title(__('Comentario'))
                ->rows(3)
                ->placeholder(__('Comentarios adicionales')),
        ];
    }
}
