<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Calificacion;

use App\Models\Calificacion;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class CalificacionListLayout extends Table
{
    public $target = 'calificaciones';

    public function columns(): array
    {
        $meses = [
            1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril',
            5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto',
            9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
        ];

        return [
            TD::make('alumno_id', __('Alumno'))
                ->render(fn (Calificacion $cal) => $cal->alumno && $cal->alumno->user 
                    ? $cal->alumno->user->name . ' ' . ($cal->alumno->user->apellido ?? '') 
                    : '-'),
            TD::make('asignatura_id', __('Asignatura'))
                ->render(fn (Calificacion $cal) => $cal->asignatura ? $cal->asignatura->nombre : '-'),
            TD::make('docente_id', __('Docente'))
                ->render(fn (Calificacion $cal) => $cal->docente && $cal->docente->user 
                    ? $cal->docente->user->name . ' ' . ($cal->docente->user->apellido ?? '') 
                    : '-'),
            TD::make('mes', __('Mes'))
                ->render(fn (Calificacion $cal) => $meses[$cal->mes] ?? $cal->mes)
                ->sort(),
            TD::make('anio', __('Año'))->sort(),
            TD::make('numero', __('Número'))->sort(),
            TD::make('nota', __('Nota'))->sort(),
            TD::make('comentario', __('Comentario'))
                ->render(fn (Calificacion $cal) => $cal->comentario ? substr($cal->comentario, 0, 50) . '...' : '-'),
            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Calificacion $cal) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.calificaciones.edit', [
                                'alumno_id' => $cal->alumno_id,
                                'asignatura_id' => $cal->asignatura_id,
                                'docente_id' => $cal->docente_id,
                                'mes' => $cal->mes,
                                'anio' => $cal->anio,
                                'numero' => $cal->numero ?? 1,
                            ])
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro?'))
                            ->method('remove', [
                                'alumno_id' => $cal->alumno_id,
                                'asignatura_id' => $cal->asignatura_id,
                                'docente_id' => $cal->docente_id,
                                'mes' => $cal->mes,
                                'anio' => $cal->anio,
                                'numero' => $cal->numero ?? 1,
                            ]),
                    ])),
        ];
    }
}
