<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Calificacion;

use App\Models\CalificacionPeriodo;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class PromediosPeriodoLayout extends Table
{
	public $target = 'promedios_periodo';

	public function columns(): array
	{
		return [
			TD::make('periodo', __('Periodo'))
				->render(function (CalificacionPeriodo $row) {
					return $row->periodo ? $row->periodo->nombre : '-';
				})
				->sort(),
			TD::make('nota', __('Nota'))
				->render(fn (CalificacionPeriodo $row) => $row->nota !== null ? number_format((float)$row->nota, 2) : '-')
				->alignRight()
				->sort(),
			TD::make('comentario', __('Comentario'))
				->render(fn (CalificacionPeriodo $row) => $row->comentario ?: '-'),
		];
	}
}


