<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Calificacion;

use Orchid\Screen\Fields\Input;
use Orchid\Screen\Fields\Select;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Layouts\Rows;

class SelectorAsignaturaAnioLayout extends Rows
{
	protected function fields(): array
	{
		$asignaturas = $this->query->get('asignaturas_options', []);
		$anios = $this->query->get('anios_options', []);
		$asignaturaId = $this->query->get('asignatura_id');
		$anio = $this->query->get('anio');
		$grupoId = $this->query->get('grupo_id');

		return [
			Select::make('asignatura_id')
				->title(__('Asignatura'))
				->options($asignaturas)
				->value($asignaturaId)
				->empty(__('Seleccione...')),

			Select::make('anio')
				->title(__('Año'))
				->options($anios)
				->value($anio),

			Input::make('grupo_id')->type('hidden')->value($grupoId),

			Button::make(__('Filtrar'))
				->icon('bs.search')
				->method('filtrar'),
		];
	}
}


