<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Calificacion;

use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class VerCalificacionesMensualesLayout extends Table
{
	public $target = 'resumen';

	public function columns(): array
	{
		$renderCalificaciones = function ($calificaciones) {
			if (empty($calificaciones) || !is_array($calificaciones)) {
				return '<span class="text-muted">-</span>';
			}
			
			// Si hay solo una calificación, mostrarla simple
			if (count($calificaciones) === 1) {
				$cal = $calificaciones[0];
				$nota = $cal['nota'] !== null ? number_format((float)$cal['nota'], 2) : '-';
				return '<span class="badge bg-primary">' . $nota . '</span>';
			}
			
			// Si hay múltiples calificaciones, mostrarlas todas con badges
			$html = '<div class="d-flex flex-wrap gap-1">';
			foreach ($calificaciones as $cal) {
				$nota = $cal['nota'] !== null ? number_format((float)$cal['nota'], 2) : '-';
				$html .= '<span class="badge bg-primary" title="Calificación #' . $cal['numero'] . ($cal['comentario'] ? ': ' . htmlspecialchars($cal['comentario']) : '') . '">' . $nota . '</span>';
			}
			$html .= '</div>';
			
			return $html;
		};
		
		return [
			TD::make('enero', __('Enero'))->render(fn ($row) => $renderCalificaciones($row['enero'] ?? null)),
			TD::make('febrero', __('Febrero'))->render(fn ($row) => $renderCalificaciones($row['febrero'] ?? null)),
			TD::make('marzo', __('Marzo'))->render(fn ($row) => $renderCalificaciones($row['marzo'] ?? null)),
			TD::make('abril', __('Abril'))->render(fn ($row) => $renderCalificaciones($row['abril'] ?? null)),
			TD::make('mayo', __('Mayo'))->render(fn ($row) => $renderCalificaciones($row['mayo'] ?? null)),
			TD::make('junio', __('Junio'))->render(fn ($row) => $renderCalificaciones($row['junio'] ?? null)),
			TD::make('julio', __('Julio'))->render(fn ($row) => $renderCalificaciones($row['julio'] ?? null)),
			TD::make('agosto', __('Agosto'))->render(fn ($row) => $renderCalificaciones($row['agosto'] ?? null)),
			TD::make('septiembre', __('Septiembre'))->render(fn ($row) => $renderCalificaciones($row['septiembre'] ?? null)),
			TD::make('octubre', __('Octubre'))->render(fn ($row) => $renderCalificaciones($row['octubre'] ?? null)),
			TD::make('noviembre', __('Noviembre'))->render(fn ($row) => $renderCalificaciones($row['noviembre'] ?? null)),
			TD::make('diciembre', __('Diciembre'))->render(fn ($row) => $renderCalificaciones($row['diciembre'] ?? null)),
		];
	}
}


