<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\CalificacionPeriodo;

use App\Models\Alumno;
use App\Models\Asignatura;
use App\Models\Docente;
use App\Models\Periodo;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Fields\TextArea;
use Orchid\Screen\Layouts\Rows;

class CalificacionPeriodoEditLayout extends Rows
{
    public function fields(): array
    {
        return [
            Relation::make('calificacionPeriodo.alumno_id')
                ->fromModel(Alumno::class, 'id')
                ->title(__('Alumno'))
                ->required()
                ->searchColumns('id')
                ->displayAppend('nombre_completo'),
            Relation::make('calificacionPeriodo.asignatura_id')
                ->fromModel(Asignatura::class, 'nombre')
                ->title(__('Asignatura'))
                ->required(),
            Relation::make('calificacionPeriodo.docente_id')
                ->fromModel(Docente::class, 'id')
                ->title(__('Docente'))
                ->required()
                ->searchColumns('id')
                ->displayAppend('nombre_completo'),
            Relation::make('calificacionPeriodo.periodo_id')
                ->fromModel(Periodo::class, 'nombre')
                ->title(__('Período Académico'))
                ->required(),
            Input::make('calificacionPeriodo.nota')
                ->type('number')
                ->step(0.01)
                ->title(__('Nota'))
                ->placeholder(__('Nota (ej: 8.5)'))
                ->min(0)
                ->max(10),
            TextArea::make('calificacionPeriodo.comentario')
                ->title(__('Comentario'))
                ->rows(3)
                ->placeholder(__('Comentarios adicionales')),
        ];
    }
}

