<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\CalificacionPeriodo;

use App\Models\CalificacionPeriodo;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class CalificacionPeriodoListLayout extends Table
{
    public $target = 'calificacionesPeriodo';

    public function columns(): array
    {
        return [
            TD::make('alumno_id', __('Alumno'))
                ->render(fn (CalificacionPeriodo $cal) => $cal->alumno && $cal->alumno->user 
                    ? $cal->alumno->user->name . ' ' . ($cal->alumno->user->apellido ?? '') 
                    : '-'),
            TD::make('asignatura_id', __('Asignatura'))
                ->render(fn (CalificacionPeriodo $cal) => $cal->asignatura ? $cal->asignatura->nombre : '-'),
            TD::make('docente_id', __('Docente'))
                ->render(fn (CalificacionPeriodo $cal) => $cal->docente && $cal->docente->user 
                    ? $cal->docente->user->name . ' ' . ($cal->docente->user->apellido ?? '') 
                    : '-'),
            TD::make('periodo_id', __('Período'))
                ->render(fn (CalificacionPeriodo $cal) => $cal->periodo ? $cal->periodo->nombre : '-')
                ->sort(),
            TD::make('nota', __('Nota'))->sort(),
            TD::make('comentario', __('Comentario'))
                ->render(fn (CalificacionPeriodo $cal) => $cal->comentario ? substr($cal->comentario, 0, 50) . '...' : '-'),
            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (CalificacionPeriodo $cal) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.calificaciones-periodo.edit', [
                                'alumno_id' => $cal->alumno_id,
                                'asignatura_id' => $cal->asignatura_id,
                                'docente_id' => $cal->docente_id,
                                'periodo_id' => $cal->periodo_id,
                            ])
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro?'))
                            ->method('remove', [
                                'alumno_id' => $cal->alumno_id,
                                'asignatura_id' => $cal->asignatura_id,
                                'docente_id' => $cal->docente_id,
                                'periodo_id' => $cal->periodo_id,
                            ]),
                    ])),
        ];
    }
}

