<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Ciclo;

use App\Models\Ciclo;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class CicloListLayout extends Table
{
    public $target = 'ciclos';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide()
                ->filter(Input::make()),

            TD::make('nombre', __('Nombre'))
                ->sort()
                ->cantHide()
                ->filter(Input::make())
                ->render(fn (Ciclo $ciclo) => Link::make($ciclo->nombre)
                    ->route('platform.systems.ciclos.edit', $ciclo->id)),

            TD::make('created_at', __('Creado'))
                ->sort()
                ->render(fn (Ciclo $ciclo) => $ciclo->created_at->format('d/m/Y H:i')),

            TD::make('updated_at', __('Actualizado'))
                ->sort()
                ->render(fn (Ciclo $ciclo) => $ciclo->updated_at->format('d/m/Y H:i')),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Ciclo $ciclo) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.ciclos.edit', $ciclo->id)
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro de eliminar este ciclo?'))
                            ->method('remove', ['id' => $ciclo->id]),
                    ])),
        ];
    }
}

