<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Colegio;

use Orchid\Screen\Field;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Fields\TextArea;
use Orchid\Screen\Layouts\Rows;

class ColegioEditLayout extends Rows
{
    /**
     * The screen's layout elements.
     *
     * @return Field[]
     */
    public function fields(): array
    {
        return [
            Input::make('colegio.nombre')
                ->type('text')
                ->max(255)
                ->required()
                ->title(__('Nombre'))
                ->placeholder(__('Nombre del colegio')),

            Input::make('colegio.direccion')
                ->type('text')
                ->max(255)
                ->title(__('Dirección'))
                ->placeholder(__('Dirección del colegio')),
        ];
    }
}

