<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Colegio;

use App\Models\Colegio;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class ColegioListLayout extends Table
{
    /**
     * @var string
     */
    public $target = 'colegios';

    /**
     * @return TD[]
     */
    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide()
                ->filter(Input::make()),

            TD::make('nombre', __('Nombre'))
                ->sort()
                ->cantHide()
                ->filter(Input::make())
                ->render(fn (Colegio $colegio) => Link::make($colegio->nombre)
                    ->route('platform.systems.colegios.edit', $colegio->id)),

            TD::make('direccion', __('Dirección'))
                ->sort()
                ->filter(Input::make()),

            TD::make('created_at', __('Creado'))
                ->sort()
                ->render(fn (Colegio $colegio) => $colegio->created_at->format('d/m/Y H:i')),

            TD::make('updated_at', __('Actualizado'))
                ->sort()
                ->render(fn (Colegio $colegio) => $colegio->updated_at->format('d/m/Y H:i')),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Colegio $colegio) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.colegios.edit', $colegio->id)
                            ->icon('bs.pencil'),

                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro de eliminar este colegio?'))
                            ->method('remove', [
                                'id' => $colegio->id,
                            ]),
                    ])),
        ];
    }
}

