<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\ColegioCiclo;

use App\Models\Ciclo;
use App\Models\Colegio;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Layouts\Rows;

class ColegioCicloEditLayout extends Rows
{
    public function fields(): array
    {
        return [
            Relation::make('colegio_ciclo.colegio_id')->fromModel(Colegio::class, 'nombre')->title(__('Colegio'))->required(),
            Relation::make('colegio_ciclo.ciclo_id')->fromModel(Ciclo::class, 'nombre')->title(__('Ciclo'))->required(),
        ];
    }
}

