<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\ColegioCiclo;

use App\Models\ColegioCiclo;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class ColegioCicloListLayout extends Table
{
    public $target = 'colegio_ciclos';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))->sort()->cantHide(),
            TD::make('colegio_id', __('Colegio'))
                ->render(fn (ColegioCiclo $cc) => $cc->colegio ? $cc->colegio->nombre : '-'),
            TD::make('ciclo_id', __('Ciclo'))
                ->render(fn (ColegioCiclo $cc) => $cc->ciclo ? $cc->ciclo->nombre : '-'),
            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (ColegioCiclo $cc) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))->route('platform.systems.colegio-ciclos.edit', $cc->id)->icon('bs.pencil'),
                        Button::make(__('Eliminar'))->icon('bs.trash3')->confirm(__('¿Está seguro?'))->method('remove', ['id' => $cc->id]),
                    ])),
        ];
    }
}

