<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Docente;

use App\Models\Asignatura;
use App\Models\Grupo;
use App\Models\User;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\DateTimer;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Fields\TextArea;
use Orchid\Screen\Layouts\Rows;

class DocenteEditLayout extends Rows
{
    public function fields(): array
    {
        return [
            Relation::make('docente.user_id')
                ->fromModel(User::class, 'name')
                ->applyScope('withDocenteRole')
                ->title(__('Usuario'))
                ->required()
                ->help(__('Seleccione el usuario que será docente')),

            Relation::make('docente.asignaturas.')
                ->fromModel(Asignatura::class, 'nombre')
                ->multiple()
                ->title(__('Asignaturas'))
                ->help(__('Seleccione las asignaturas que puede dictar este docente (puede seleccionar múltiples)')),

            Relation::make('docente.grupos.')
                ->fromModel(Grupo::class, 'nombre_grupo')
                ->multiple()
                ->title(__('Grupos'))
                ->help(__('Seleccione los grupos a los que está asignado este docente (puede seleccionar múltiples)')),

            DateTimer::make('docente.fecha_ingreso')
                ->title(__('Fecha de Ingreso'))
                ->format('Y-m-d')
                ->allowInput(),

            TextArea::make('docente.observaciones')
                ->title(__('Observaciones'))
                ->rows(3)
                ->placeholder(__('Observaciones adicionales')),
        ];
    }
}

