<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Docente;

use App\Models\Docente;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class DocenteListLayout extends Table
{
    public $target = 'docentes';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide()
                ->filter(Input::make()),

            TD::make('user_id', __('Usuario'))
                ->sort()
                ->render(fn (Docente $docente) => $docente->user ? $docente->user->name . ' ' . ($docente->user->apellido ?? '') : '-'),

            TD::make('fecha_ingreso', __('Fecha Ingreso'))
                ->sort()
                ->render(fn (Docente $docente) => $docente->fecha_ingreso ? $docente->fecha_ingreso->format('d/m/Y') : '-'),

            TD::make('asignaturas', __('Asignaturas'))
                ->render(function (Docente $docente) {
                    if ($docente->asignaturas->isEmpty()) {
                        return '<span class="text-muted">-</span>';
                    }
                    return $docente->asignaturas->pluck('nombre')->join(', ');
                }),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Docente $docente) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.docentes.edit', $docente->id)
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro de eliminar este docente?'))
                            ->method('remove', ['id' => $docente->id]),
                    ])),
        ];
    }
}

