<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Grupo;

use App\Models\Alumno;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class GrupoAlumnosLayout extends Table
{
    public $target = 'alumnos';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide(),

            TD::make('user_id', __('Nombre Completo'))
                ->sort()
                ->render(fn (Alumno $alumno) => $alumno->user 
                    ? $alumno->user->name . ' ' . ($alumno->user->apellido ?? '') 
                    : '-'),

            TD::make('fecha_ingreso', __('Fecha Ingreso'))
                ->sort()
                ->render(fn (Alumno $alumno) => $alumno->fecha_ingreso 
                    ? $alumno->fecha_ingreso->format('d/m/Y') 
                    : '-'),

            TD::make('nombre_contacto_emergencia', __('Contacto Emergencia'))
                ->sort(),

            TD::make('tel_contacto_emergencia', __('Teléfono Emergencia'))
                ->sort(),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(function (Alumno $alumno) {
                    $grupo = $this->query->get('grupo');
                    $grupoId = $grupo ? $grupo->id : (request()->route('grupo')?->id ?? null);
                    return DropDown::make()
                        ->icon('bs.three-dots-vertical')
                        ->list([
                            Link::make(__('Calificar'))
                                ->icon('bs.star')
                                ->route('platform.systems.alumnos.calificaciones', [
                                    'alumno' => $alumno->id,
                                    'grupo_id' => $grupoId,
                                ]),
                            Link::make(__('Cerrar promedios'))
                                ->icon('bs.calendar-check')
                                ->route('platform.systems.calificaciones-periodo'),
                            Link::make(__('Ver calificaciones'))
                                ->icon('bs.eye')
                                ->route('platform.systems.alumnos.ver_calificaciones', [
                                    'alumno' => $alumno->id,
                                    'grupo_id' => $grupoId,
                                ]),
                        ]);
                }),
        ];
    }
}

