<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Grupo;

use App\Models\Ciclo;
use App\Models\Colegio;
use App\Models\Turno;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Layouts\Rows;

class GrupoEditLayout extends Rows
{
    public function fields(): array
    {
        return [
            Relation::make('grupo.colegio_id')
                ->fromModel(Colegio::class, 'nombre')
                ->title(__('Colegio'))
                ->required()
                ->help(__('Seleccione el colegio')),
            Relation::make('grupo.ciclo_id')
                ->fromModel(Ciclo::class, 'nombre')
                ->title(__('Ciclo'))
                ->required()
                ->help(__('Seleccione el ciclo')),
            Relation::make('grupo.turno_id')->fromModel(Turno::class, 'nombre')->title(__('Turno'))->required(),
            Input::make('grupo.nombre_grupo')->type('text')->max(255)->required()->title(__('Nombre del Grupo')),
        ];
    }
}

