<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Grupo;

use App\Models\Grupo;
use Illuminate\Support\Facades\Auth;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class GrupoListLayout extends Table
{
    public $target = 'grupos';

    public function columns(): array
    {
        $user = Auth::user();
        $isDocente = $user && $user->docente;
        
        return [
            TD::make('id', __('ID'))->sort()->cantHide(),
            TD::make('nombre_grupo', __('Nombre Grupo'))->sort(),
            TD::make('colegio_ciclo_id', __('Colegio-Ciclo'))
                ->render(fn (Grupo $grupo) => $grupo->colegioCiclo && $grupo->colegioCiclo->colegio && $grupo->colegioCiclo->ciclo 
                    ? $grupo->colegioCiclo->colegio->nombre . ' - ' . $grupo->colegioCiclo->ciclo->nombre 
                    : '-'),
            TD::make('turno_id', __('Turno'))
                ->render(fn (Grupo $grupo) => $grupo->turno ? $grupo->turno->nombre : '-'),
            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(function (Grupo $grupo) use ($isDocente) {
                    $actions = [
                        Link::make(__('Ver Alumnos'))->route('platform.systems.grupos.alumnos', $grupo->id)->icon('bs.people'),
                    ];
                    
                    // Solo mostrar acciones de editar y eliminar si NO es docente
                    if (!$isDocente) {
                        $actions[] = Link::make(__('Editar'))->route('platform.systems.grupos.edit', $grupo->id)->icon('bs.pencil');
                        $actions[] = Button::make(__('Eliminar'))->icon('bs.trash3')->confirm(__('¿Está seguro?'))->method('remove', ['id' => $grupo->id]);
                    }
                    
                    return DropDown::make()
                        ->icon('bs.three-dots-vertical')
                        ->list($actions);
                }),
        ];
    }
}

