<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Padre;

use App\Models\Alumno;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class PadreAlumnosLayout extends Table
{
    public $target = 'alumnos';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide(),

            TD::make('user_id', __('Nombre Completo'))
                ->sort()
                ->render(fn (Alumno $alumno) => $alumno->user 
                    ? $alumno->user->name . ' ' . ($alumno->user->apellido ?? '') 
                    : '-'),

            TD::make('fecha_ingreso', __('Fecha Ingreso'))
                ->sort()
                ->render(fn (Alumno $alumno) => $alumno->fecha_ingreso 
                    ? $alumno->fecha_ingreso->format('d/m/Y') 
                    : '-'),

            TD::make('nombre_contacto_emergencia', __('Contacto Emergencia'))
                ->sort(),

            TD::make('tel_contacto_emergencia', __('Teléfono Emergencia'))
                ->sort(),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Alumno $alumno) => Link::make(__('Editar'))
                    ->route('platform.systems.alumnos.edit', $alumno->id)
                    ->icon('bs.pencil')),
        ];
    }
}

