<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Padre;

use App\Models\User;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Fields\Select;
use Orchid\Screen\Fields\TextArea;
use Orchid\Screen\Layouts\Rows;

class PadreEditLayout extends Rows
{
    public function fields(): array
    {
        return [
            Relation::make('padre.user_id')
                ->fromModel(User::class, 'name')
                ->applyScope('withPadreRole')
                ->title(__('Usuario'))
                ->required(),
            Select::make('padre.tipo_relacion')
                ->title(__('Tipo de Relación'))
                ->options([
                    'Padre' => 'Padre',
                    'Madre' => 'Madre',
                    'Abuelo' => 'Abuelo',
                    'Tutor' => 'Tutor',
                ]),
            TextArea::make('padre.observaciones')->title(__('Observaciones'))->rows(3),
        ];
    }
}

