<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Padre;

use App\Models\Padre;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class PadreListLayout extends Table
{
    public $target = 'padres';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))->sort()->cantHide(),
            TD::make('user_id', __('Usuario'))
                ->render(fn (Padre $padre) => $padre->user ? $padre->user->name . ' ' . ($padre->user->apellido ?? '') : '-'),
            TD::make('tipo_relacion', __('Tipo Relación'))->sort(),
            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Padre $padre) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))->route('platform.systems.padres.edit', $padre->id)->icon('bs.pencil'),
                        Button::make(__('Eliminar'))->icon('bs.trash3')->confirm(__('¿Está seguro?'))->method('remove', ['id' => $padre->id]),
                    ])),
        ];
    }
}

