<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Periodo;

use Orchid\Screen\Field;
use Orchid\Screen\Fields\DateTimer;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Rows;

class PeriodoEditLayout extends Rows
{
    public function fields(): array
    {
        return [
            Input::make('periodo.nombre')
                ->title(__('Nombre del Período'))
                ->placeholder(__('Ej: "Marzo - Abril", "1er Trimestre"'))
                ->required()
                ->maxlength(100),
            DateTimer::make('periodo.fecha_inicio')
                ->title(__('Fecha de Inicio'))
                ->format('Y-m-d')
                ->required()
                ->allowInput(),
            DateTimer::make('periodo.fecha_fin')
                ->title(__('Fecha de Fin'))
                ->format('Y-m-d')
                ->required()
                ->allowInput(),
        ];
    }
}

