<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Periodo;

use App\Models\Periodo;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class PeriodoListLayout extends Table
{
    public $target = 'periodos';

    public function columns(): array
    {
        return [
            TD::make('nombre', __('Nombre'))->sort(),
            TD::make('fecha_inicio', __('Fecha Inicio'))
                ->render(fn (Periodo $periodo) => $periodo->fecha_inicio ? $periodo->fecha_inicio->format('d/m/Y') : '-')
                ->sort(),
            TD::make('fecha_fin', __('Fecha Fin'))
                ->render(fn (Periodo $periodo) => $periodo->fecha_fin ? $periodo->fecha_fin->format('d/m/Y') : '-')
                ->sort(),
            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Periodo $periodo) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.periodos.edit', $periodo)
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro?'))
                            ->method('remove', ['id' => $periodo->id]),
                    ])),
        ];
    }
}

