<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Role;

use Orchid\Screen\Field;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Rows;

class RoleEditLayout extends Rows
{
    /**
     * The screen's layout elements.
     *
     * @return Field[]
     */
    public function fields(): array
    {
        return [
            Input::make('role.name')
                ->type('text')
                ->max(255)
                ->required()
                ->title(__('Name'))
                ->placeholder(__('Name'))
                ->help(__('Role display name'))
                ->id('role-name-input'),

            Input::make('role.slug')
                ->type('text')
                ->max(255)
                ->title(__('Slug'))
                ->placeholder(__('Slug'))
                ->help(__('Actual name in the system (generated automatically)'))
                ->id('role-slug-input')
                ->readonly(),
        ];
    }
}
