<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\Turno;

use App\Models\Turno;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\DropDown;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Table;
use Orchid\Screen\TD;

class TurnoListLayout extends Table
{
    public $target = 'turnos';

    public function columns(): array
    {
        return [
            TD::make('id', __('ID'))
                ->sort()
                ->cantHide()
                ->filter(Input::make()),

            TD::make('nombre', __('Nombre'))
                ->sort()
                ->cantHide()
                ->filter(Input::make())
                ->render(fn (Turno $turno) => Link::make($turno->nombre)
                    ->route('platform.systems.turnos.edit', $turno->id)),

            TD::make('created_at', __('Creado'))
                ->sort()
                ->render(fn (Turno $turno) => $turno->created_at->format('d/m/Y H:i')),

            TD::make('updated_at', __('Actualizado'))
                ->sort()
                ->render(fn (Turno $turno) => $turno->updated_at->format('d/m/Y H:i')),

            TD::make(__('Acciones'))
                ->align(TD::ALIGN_CENTER)
                ->width('100px')
                ->render(fn (Turno $turno) => DropDown::make()
                    ->icon('bs.three-dots-vertical')
                    ->list([
                        Link::make(__('Editar'))
                            ->route('platform.systems.turnos.edit', $turno->id)
                            ->icon('bs.pencil'),
                        Button::make(__('Eliminar'))
                            ->icon('bs.trash3')
                            ->confirm(__('¿Está seguro de eliminar este turno?'))
                            ->method('remove', ['id' => $turno->id]),
                    ])),
        ];
    }
}

