<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\User;

use App\Models\User;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Layouts\Rows;

class UserEditLayout extends Rows
{
    /**
     * The screen's layout elements.
     *
     * @return Field[]
     */
    public function fields(): array
    {
        /** @var User $user */
        $user = $this->query->get('user');
        $userExists = $user && $user->exists;

        return [
            Input::make('user.name')
                ->type('text')
                ->max(255)
                ->required()
                ->title(__('Name'))
                ->placeholder(__('Name')),

            Input::make('user.email')
                ->type('email')
                ->required()
                ->title(__('Email'))
                ->placeholder(__('Email')),

            Input::make('user.telefono')
                ->type('text')
                ->max(255)
                ->title('Teléfono')
                ->placeholder('Número de teléfono'),

            Input::make('user.foto_actual')
                ->type('text')
                ->readonly()
                ->title(__('Foto Actual'))
                ->help(__('Nombre del archivo de foto de perfil actual'))
                ->canSee($userExists),

            Input::make('user.foto')
                ->type('file')
                ->accept('image/jpeg,image/png,image/jpg,image/gif')
                ->title(__('Foto de Perfil'))
                ->help(__('Seleccione una imagen para la foto de perfil. Formatos permitidos: JPG, PNG, GIF. Se guardará como avatar.jpg')),
        ];
    }
}
