<?php

declare(strict_types=1);

namespace App\Orchid\Layouts\User;

use Orchid\Platform\Models\Role;
use Orchid\Screen\Field;
use Orchid\Screen\Fields\Relation;
use Orchid\Screen\Layouts\Rows;

class UserRoleLayout extends Rows
{
    /**
     * The screen's layout elements.
     *
     * @return Field[]
     */
    public function fields(): array
    {
        return [
            Relation::make('user.roles.')
                ->fromModel(Role::class, 'name')
                ->multiple()
                ->required()
                ->title(__('Name role'))
                ->help(__('Select one or more roles from the list. The user will inherit all permissions from the assigned roles.'))
                ->chunk(20),
        ];
    }
}
