<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Adscripto;

use App\Models\Adscripto;
use App\Orchid\Layouts\Adscripto\AdscriptoEditLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Screen;
use Orchid\Support\Color;
use Orchid\Support\Facades\Layout;
use Orchid\Support\Facades\Toast;

class AdscriptoEditScreen extends Screen
{
    public $adscripto;

    public function query(Adscripto $adscripto): iterable
    {
        $adscripto->load('user');
        return ['adscripto' => $adscripto];
    }

    public function name(): ?string { return $this->adscripto->exists ? 'Editar Adscripto' : 'Crear Adscripto'; }
    public function description(): ?string { return 'Información del adscripto.'; }
    public function permission(): ?iterable { return null; }

    public function commandBar(): iterable
    {
        return [
            Button::make(__('Eliminar'))->icon('bs.trash3')->confirm(__('¿Está seguro?'))->method('remove')->canSee($this->adscripto->exists),
            Button::make(__('Guardar'))->icon('bs.check-circle')->method('save'),
        ];
    }

    public function layout(): iterable
    {
        return [
            Layout::block(AdscriptoEditLayout::class)
                ->title(__('Información del Adscripto'))
                ->commands(Button::make(__('Guardar'))->type(Color::BASIC)->icon('bs.check-circle')->canSee($this->adscripto->exists)->method('save')),
        ];
    }

    public function save(Adscripto $adscripto, Request $request)
    {
        $request->validate([
            'adscripto.user_id' => 'required|exists:users,id|unique:adscriptos,user_id,' . $adscripto->id,
            'adscripto.fecha_ingreso' => 'nullable|date',
            'adscripto.observaciones' => 'nullable|string',
        ]);
        $adscripto->fill($request->get('adscripto'))->save();
        Toast::info(__('Adscripto guardado correctamente'));
        return redirect()->route('platform.systems.adscriptos');
    }

    public function remove(Adscripto $adscripto)
    {
        $adscripto->delete();
        Toast::info(__('Adscripto eliminado correctamente'));
        return redirect()->route('platform.systems.adscriptos');
    }
}

