<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Adscripto;

use App\Models\Adscripto;
use App\Orchid\Layouts\Adscripto\AdscriptoListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class AdscriptoListScreen extends Screen
{
    public function query(): iterable
    {
        return ['adscriptos' => Adscripto::with('user')->defaultSort('id', 'desc')->paginate()];
    }

    public function name(): ?string { return 'Gestión de Adscriptos'; }
    public function description(): ?string { return 'Lista de adscriptos registrados.'; }
    public function permission(): ?iterable { return null; }

    public function commandBar(): iterable
    {
        return [Link::make(__('Agregar'))->icon('bs.plus-circle')->route('platform.systems.adscriptos.create')];
    }

    public function layout(): iterable { return [AdscriptoListLayout::class]; }

    public function remove(Request $request): void
    {
        Adscripto::findOrFail($request->get('id'))->delete();
        Toast::info(__('Adscripto eliminado correctamente'));
    }
}

