<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Alumno;

use App\Models\Alumno;
use App\Orchid\Layouts\Alumno\AlumnoListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class AlumnoListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'alumnos' => Alumno::with('user', 'grupos')->defaultSort('id', 'desc')->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Gestión de Alumnos';
    }

    public function description(): ?string
    {
        return 'Lista completa de todos los alumnos registrados en el sistema.';
    }

    public function permission(): ?iterable
    {
        return null; // Sin restricción de permisos
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.alumnos.create'),
        ];
    }

    public function layout(): iterable
    {
        return [AlumnoListLayout::class];
    }

    public function remove(Request $request): void
    {
        Alumno::findOrFail($request->get('id'))->delete();
        Toast::info(__('Alumno eliminado correctamente'));
    }
}

