<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Asignatura;

use App\Models\Asignatura;
use App\Orchid\Layouts\Asignatura\AsignaturaListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class AsignaturaListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'asignaturas' => Asignatura::defaultSort('id', 'desc')->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Gestión de Asignaturas';
    }

    public function description(): ?string
    {
        return 'Lista completa de todas las asignaturas registradas en el sistema.';
    }

    public function permission(): ?iterable
    {
        return null; // Sin restricción de permisos
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.asignaturas.create'),
        ];
    }

    public function layout(): iterable
    {
        return [AsignaturaListLayout::class];
    }

    public function remove(Request $request): void
    {
        Asignatura::findOrFail($request->get('id'))->delete();
        Toast::info(__('Asignatura eliminada correctamente'));
    }
}

