<?php

declare(strict_types=1);

namespace App\Orchid\Screens\Calificacion;

use App\Models\Calificacion;
use App\Orchid\Layouts\Calificacion\CalificacionListLayout;
use Illuminate\Http\Request;
use Orchid\Screen\Actions\Link;
use Orchid\Screen\Screen;
use Orchid\Support\Facades\Toast;

class CalificacionListScreen extends Screen
{
    public function query(): iterable
    {
        return [
            'calificaciones' => Calificacion::with(['alumno.user', 'asignatura', 'docente.user'])
                ->orderBy('anio', 'desc')
                ->orderBy('mes', 'desc')
                ->paginate(),
        ];
    }

    public function name(): ?string
    {
        return 'Gestión de Calificaciones';
    }

    public function description(): ?string
    {
        return 'Lista de calificaciones por alumno, asignatura y docente.';
    }

    public function permission(): ?iterable
    {
        return null;
    }

    public function commandBar(): iterable
    {
        return [
            Link::make(__('Agregar'))
                ->icon('bs.plus-circle')
                ->route('platform.systems.calificaciones.create'),
        ];
    }

    public function layout(): iterable
    {
        return [CalificacionListLayout::class];
    }

    public function remove(Request $request): void
    {
        $query = Calificacion::where('alumno_id', $request->get('alumno_id'))
            ->where('asignatura_id', $request->get('asignatura_id'))
            ->where('docente_id', $request->get('docente_id'))
            ->where('mes', $request->get('mes'))
            ->where('anio', $request->get('anio'));
        
        // Si viene numero, eliminar solo esa calificación específica
        if ($request->has('numero')) {
            $query->where('numero', $request->get('numero'));
        }
        
        $query->delete();
        Toast::info(__('Calificación eliminada correctamente'));
    }
}
